/*-----------------------------------------------------------
	stack.c
	
	implements a simple stack of integers
	
	William May
	303A Ridgefield Circle
	Clinton, MA 01510
	
	2/20/87		created
  -----------------------------------------------------------*/

#ifdef DEBUG
#include <stdio.h>
#endif

#include <storage.h>

typedef struct STACK {
	int max;		/* max items in stack */
	int top;		/* current items in stack */
	int items[];	/* the data */
} STACK;

/* some error codes */
#define FULL  -2
#define EMPTY -1
#define NOERR  0

#ifdef DEBUG

STACK *mystack;

main()
{
	STACK *init_stack();
	int num, c;
	
	printf("Stack program begun\n");
	
	if (!(mystack = init_stack(5))) {
		fprintf(stderr, "Insufficient memory to create stack\n");
		ExitToShell();
	}
	
	while( 1 ) { 
		num = c = -1;
	
		printf("top	     = %d\n", mystack->top);
		printf("max	     = %d\n", mystack->max);
		printf("top item = %d\n", top_of_stack(mystack));


		printf("\n<p(op)/s(push)/q(uit)> -> ");
		while( c != 'p' && c != 's' && c != 'q' )
			c = getchar();

		if( c == 's' )
		{			
			printf("\nenter decimal number -> ");
			scanf("%d", &num );
			printf("\npush(%d) returned %d\n",
						num, push(num, mystack));
		}
		else if( c == 'p' )
		{
			printf( "\npop returned: %d\n", pop(mystack));
		}
		else
			break;
	}

	del_stack(&mystack);
	
	printf("\nStack program complete\n");
}
#endif

/*-------------------------------------------------------------------
	create the stack
	NULL returned if insufficient memory
  -------------------------------------------------------------------*/
STACK *init_stack	( items )
int items;
{
	STACK * p;
	
	if (p = (STACK *)calloc ((sizeof(int) * items + sizeof(STACK)),1)) {
		p->max = items;
		p->top = EMPTY;
	}
	
	return (p);
}

/*-------------------------------------------------------------------
	delete the stack
  -------------------------------------------------------------------*/
void del_stack ( stackptr )
STACK **stackptr;
{
	free(*stackptr);
	*stackptr = 0L;
}

/*-------------------------------------------------------------------
	is the stack empty?
  -------------------------------------------------------------------*/
int empty ( stack )
STACK *stack;
{
	return ((stack->top == EMPTY) ? 1 : 0);
}

/*-------------------------------------------------------------------
	return the top element of the stack and decrement
	the stack pointer
  -------------------------------------------------------------------*/
int pop ( stack )
STACK *stack;
{
	if (empty(stack))
		return EMPTY;
	else {
		return (stack->items[stack->top--]);
	}
}

/*-------------------------------------------------------------------
	push an integer onto the stack and increment the stack pointer
  -------------------------------------------------------------------*/
int push (n, stack)
int n;
STACK *stack;
{
	if (++stack->top < stack->max) {
		stack->items[stack->top] = n;
		return NOERR;
	}
	else {
		--stack->top;
		return FULL;
	}
}

/*-------------------------------------------------------------------
	look at the top of the stack without changing the
	stack pointer
  -------------------------------------------------------------------*/
int top_of_stack( stack )
STACK *stack;
{
	return (stack->items[stack->top]);
}

